# 4.0.0

Starting with this version, OpenLayers introduces [Semantic Versioning](http://semver.org). Unlike the switch from v2.x to v3.x, which marked a complete rewrite of the library with an entirely new API, major version increments now simply mean that users should pay attention to the *'Breaking changes'* section of the upgrade notes.

For users of mainstream bundlers and minifiers, OpenLayers is now also available as a set of ES2015 modules. See https://npmjs.com/package/ol/. With that package, bundling only the needed parts of the library with an application is now completely hassle free.

Version 4.0.0 includes enhancements and fixes from 107 pull requests since the previous release.

Among these changes, [#6381](https://github.com/openlayers/openlayers/pull/6381) adds an example which shows how to use [geojson-vt](https://www.npmjs.com/package/geojson-vt) for highly efficient rendering of GeoJSON data as vector tiles.

Several improvements were made to `ol.source.Zoomify`, including projection support ([#6387](https://github.com/openlayers/openlayers/pull/6387)) and support for URL templates ([#6475](https://github.com/openlayers/openlayers/pull/6475)).

Also the `ol.source.ImageArcGISRest` saw some enhancements, including HiDPI/Retina support and a fix that avoids non-integer DPI values ([#6300](https://github.com/openlayers/openlayers/pull/6300) and [#6467](https://github.com/openlayers/openlayers/pull/6467)).

On the topic of drawing tools, @tst-ppenev completed an effort to make the `ol.interaction.Modify` interaction support modification of `ol.geom.Circle` geometries ([#6457](https://github.com/openlayers/openlayers/pull/6457)).


## Breaking changes

### Simplified `ol.View#fit()` API

In most cases, it is no longer necessary to provide an `ol.Size` (previously the 2nd argument) to `ol.View#fit()`. By default, the size of the first map that uses the view will be used. If you want to specify a different size, it goes in the options now (previously the 3rd argument, now the 2nd).

Most common use case - old API:
```js
map.getView().fit(extent, map.getSize());
```
Most common use case - new API:
```js
map.getView().fit(extent);
```
Advanced use - old API:
```js
map.getView().fit(extent, [200, 100], {padding: 10});
```
Advanced use - new API:
```js
map.getView().fit(extent, {size: [200, 100], padding 10});
```

### Removal of deprecated methods

The deprecated `ol.animation` functions and `map.beforeRender()` method have been removed.  Use `view.animate()` instead.

The `unByKey()` method has been removed from `ol.Observable` instances.  Use the `ol.Observable.unByKey()` static function instead.
```js
var key = map.on('moveend', function() { ...});
map.unByKey(key);
```
New code:
```js
var key = map.on('moveend', function() { ...});
ol.Observable.unByKey(key);
```

## Upgrade notes

### Simpler `ol.source.Zoomify` `url` configuration

Instead specifying a base url, the `url` for the `ol.source.Zoomify` source can now be a template.  The `{TileGroup}`, `{x}`, `{y}`, `{z}` and placeholders must be included in the `url` in this case. the `url` can now also include subdomain placeholders:
```js
new ol.source.Zoomify({
  url: 'https://{a-f}.example.com/cgi-bin/iipsrv.fcgi?zoomify=/a/b/{TileGroup}/{z}-{x}-{y}.jpg'
});
```

#### Removed build flags (`@define`)

The `ol.DEBUG`, `ol.ENABLE_TILE`, `ol.ENABLE_IMAGE`, `ol.ENABLE_VECTOR`, and `ol.ENABLE_VECTOR_TILE` build flags are no longer necessary and have been removed.  If you were using these in a `define` array for a custom build, you can remove them.

If you leave `ol.ENABLE_WEBGL` set to `true` in your build, you should set `ol.DEBUG_WEBGL` to `false` to avoid including debuggable shader sources.


## List of all changes

 * [#6477](https://github.com/openlayers/openlayers/pull/6477) - Save and restore context when rotating ([@ahocevar](https://github.com/ahocevar))
 * [#6475](https://github.com/openlayers/openlayers/pull/6475) - Use an url template for ol.source.Zoomify ([@fredj](https://github.com/fredj))
 * [#6478](https://github.com/openlayers/openlayers/pull/6478) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6472](https://github.com/openlayers/openlayers/pull/6472) - Use fixed pixel ratio for hit tolerance tests ([@ahocevar](https://github.com/ahocevar))
 * [#6468](https://github.com/openlayers/openlayers/pull/6468) - Remove console.assert in ol.structs.PriorityQueue tests ([@fredj](https://github.com/fredj))
 * [#6467](https://github.com/openlayers/openlayers/pull/6467) - Round the DPI value in ol.source.ImageArcGISRest ([@fredj](https://github.com/fredj))
 * [#6466](https://github.com/openlayers/openlayers/pull/6466) - Small XML error in KML test ([@tchandelle](https://github.com/tchandelle))
 * [#6410](https://github.com/openlayers/openlayers/pull/6410) - fixed the degreesToStringHDMS_() function to promote a seconds value … ([@rjackson64840](https://github.com/rjackson64840))
 * [#6461](https://github.com/openlayers/openlayers/pull/6461) - Add button to edit examples in CodePen ([@tchandelle](https://github.com/tchandelle))
 * [#6320](https://github.com/openlayers/openlayers/pull/6320) - Use the 'openlayers' tag instead of 'openlayers-3' ([@ahocevar](https://github.com/ahocevar))
 * [#6460](https://github.com/openlayers/openlayers/pull/6460) - Remove ol.Observable#unByKey ([@fredj](https://github.com/fredj))
 * [#6463](https://github.com/openlayers/openlayers/pull/6463) - chore(package): update clean-css-cli to version 4.0.5 ([@openlayers](https://github.com/openlayers))
 * [#6459](https://github.com/openlayers/openlayers/pull/6459) - Use ol.coordinate.distance ([@fredj](https://github.com/fredj))
 * [#6457](https://github.com/openlayers/openlayers/pull/6457) - Add Circle Modification ([@tst-ppenev](https://github.com/tst-ppenev))
 * [#6455](https://github.com/openlayers/openlayers/pull/6455) - Make all @api annotations imply stability ([@tschaub](https://github.com/tschaub))
 * [#6452](https://github.com/openlayers/openlayers/pull/6452) - Remove deprecated methods ([@tschaub](https://github.com/tschaub))
 * [#6361](https://github.com/openlayers/openlayers/pull/6361) - Remove "margin" at the bottom of the canvas ([@tchandelle](https://github.com/tchandelle))
 * [#6450](https://github.com/openlayers/openlayers/pull/6450) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6302](https://github.com/openlayers/openlayers/pull/6302) - Publish a package for use with ES module bundlers ([@tschaub](https://github.com/tschaub))
 * [#6446](https://github.com/openlayers/openlayers/pull/6446) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6445](https://github.com/openlayers/openlayers/pull/6445) - Fix pinch zooming ([@tschaub](https://github.com/tschaub))
 * [#6444](https://github.com/openlayers/openlayers/pull/6444) - Disallow pinch zooming beyond min/max resolution ([@tschaub](https://github.com/tschaub))
 * [#6443](https://github.com/openlayers/openlayers/pull/6443) - goog.require cleanup ([@openlayers](https://github.com/openlayers))
 * [#6439](https://github.com/openlayers/openlayers/pull/6439) - Improve tile render performance ([@ahocevar](https://github.com/ahocevar))
 * [#6442](https://github.com/openlayers/openlayers/pull/6442) - Fix missing goog.require ([@fredj](https://github.com/fredj))
 * [#6441](https://github.com/openlayers/openlayers/pull/6441) - Update metalsmith-layouts to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6437](https://github.com/openlayers/openlayers/pull/6437) - Fit on circle ([@tchandelle](https://github.com/tchandelle))
 * [#6427](https://github.com/openlayers/openlayers/pull/6427) - Ensure WMS width and height are always integers ([@ahocevar](https://github.com/ahocevar))
 * [#6432](https://github.com/openlayers/openlayers/pull/6432) - Use ol.proj.EPSG3857.WORLD_EXTENT in ol.source.TileImage tests ([@fredj](https://github.com/fredj))
 * [#6424](https://github.com/openlayers/openlayers/pull/6424) - Update dependencies to enable Greenkeeper 🌴 ([@openlayers](https://github.com/openlayers))
 * [#6422](https://github.com/openlayers/openlayers/pull/6422) - Don't listen twice to move and end events in ol.control.ZoomSlider ([@fredj](https://github.com/fredj))
 * [#6426](https://github.com/openlayers/openlayers/pull/6426) - Add rewrite_polyfills to custom builds tutorial ([@probins](https://github.com/probins))
 * [#6365](https://github.com/openlayers/openlayers/pull/6365) - Make enums for draw and modify interactions public ([@gberaudo](https://github.com/gberaudo))
 * [#6294](https://github.com/openlayers/openlayers/pull/6294) - Update code for closure-compiler v20170124 ([@fredj](https://github.com/fredj))
 * [#6413](https://github.com/openlayers/openlayers/pull/6413) - Accept ol.StyleFunction in ol.Feature#setStyle() ([@ahocevar](https://github.com/ahocevar))
 * [#6398](https://github.com/openlayers/openlayers/pull/6398) - Be more tolerant of map and position value ([@fredj](https://github.com/fredj))
 * [#6399](https://github.com/openlayers/openlayers/pull/6399) - Small doc fix in VectorTileOptions renderMode ([@tchandelle](https://github.com/tchandelle))
 * [#6396](https://github.com/openlayers/openlayers/pull/6396) - Show current year in attribution in "HERE Map Tile API" example ([@chrismayer](https://github.com/chrismayer))
 * [#6390](https://github.com/openlayers/openlayers/pull/6390) - Tag deprecated functions with @deprecated ([@fredj](https://github.com/fredj))
 * [#6370](https://github.com/openlayers/openlayers/pull/6370) - Feature apidoc, fix events and observable properties ([@tchandelle](https://github.com/tchandelle))
 * [#6376](https://github.com/openlayers/openlayers/pull/6376) - Make ol.format.filter.or/and accept n filter conditions ([@tsauerwein](https://github.com/tsauerwein))
 * [#6393](https://github.com/openlayers/openlayers/pull/6393) - Only stop animation when animating ([@ahocevar](https://github.com/ahocevar))
 * [#6387](https://github.com/openlayers/openlayers/pull/6387) - Add projection option to ol.source.Zoomify ([@ahocevar](https://github.com/ahocevar))
 * [#6386](https://github.com/openlayers/openlayers/pull/6386) - Snap : only listen to change event triggered by the feature ([@tchandelle](https://github.com/tchandelle))
 * [#6383](https://github.com/openlayers/openlayers/pull/6383) - Modify interaction: check if interaction is active before drawing modifying vertex ([@tchandelle](https://github.com/tchandelle))
 * [#6381](https://github.com/openlayers/openlayers/pull/6381) - geojson-vt integration example ([@drnextgis](https://github.com/drnextgis))
 * [#6373](https://github.com/openlayers/openlayers/pull/6373) - Use the ol.DEBUG_WEBGL flag to debug shader sources ([@tschaub](https://github.com/tschaub))
 * [#6379](https://github.com/openlayers/openlayers/pull/6379) - Set the overview map target in ol.control.OverviewMap.setMap ([@fredj](https://github.com/fredj))
 * [#6375](https://github.com/openlayers/openlayers/pull/6375) - Use present in license text ([@bartvde](https://github.com/bartvde))
 * [#6371](https://github.com/openlayers/openlayers/pull/6371) - Adjust copyright to include 2017 ([@kolosov-sergey](https://github.com/kolosov-sergey))
 * [#6364](https://github.com/openlayers/openlayers/pull/6364) - Make sure moveTo is called after beginPath ([@ahocevar](https://github.com/ahocevar))
 * [#6285](https://github.com/openlayers/openlayers/pull/6285) - Make size argument of ol.View#calculateExtent() optional ([@ahocevar](https://github.com/ahocevar))
 * [#6357](https://github.com/openlayers/openlayers/pull/6357) - Fix GeoJSONCRSCode definition ([@fredj](https://github.com/fredj))
 * [#6362](https://github.com/openlayers/openlayers/pull/6362) - Remove empty file ([@fredj](https://github.com/fredj))
 * [#6358](https://github.com/openlayers/openlayers/pull/6358) - Ensure polygons without stroke are fully filled ([@ahocevar](https://github.com/ahocevar))
 * [#6356](https://github.com/openlayers/openlayers/pull/6356) - Bring custom builds tutorial up to date ([@probins](https://github.com/probins))
 * [#6359](https://github.com/openlayers/openlayers/pull/6359) - When applying a pending fill, also apply a pending stroke ([@ahocevar](https://github.com/ahocevar))
 * [#6360](https://github.com/openlayers/openlayers/pull/6360) - Remove ol.array.flatten function ([@openlayers](https://github.com/openlayers))
 * [#6353](https://github.com/openlayers/openlayers/pull/6353) - API doc : add highlight style to the active anchor ([@tchandelle](https://github.com/tchandelle))
 * [#6355](https://github.com/openlayers/openlayers/pull/6355) - Remove test.geojson which was accidently committed in 57342a6 ([@ahocevar](https://github.com/ahocevar))
 * [#6349](https://github.com/openlayers/openlayers/pull/6349) - Better documentation for icon-color example ([@ahocevar](https://github.com/ahocevar))
 * [#6351](https://github.com/openlayers/openlayers/pull/6351) - Only consider pointerdown event if the last pointerup has been emitted ([@tchandelle](https://github.com/tchandelle))
 * [#6345](https://github.com/openlayers/openlayers/pull/6345) - Mitigate rounding errors in GetMap width/height calculation ([@giohappy](https://github.com/giohappy))
 * [#6344](https://github.com/openlayers/openlayers/pull/6344) - No special raster reprojection handling for Chrome ([@ahocevar](https://github.com/ahocevar))
 * [#6339](https://github.com/openlayers/openlayers/pull/6339) - Code cleanup ([@fredj](https://github.com/fredj))
 * [#6337](https://github.com/openlayers/openlayers/pull/6337) - Constrain center in DragZoom interaction ([@tchandelle](https://github.com/tchandelle))
 * [#6336](https://github.com/openlayers/openlayers/pull/6336) - Remove unused ol.format.Feature.getExtensions function ([@fredj](https://github.com/fredj))
 * [#6333](https://github.com/openlayers/openlayers/pull/6333) - Use API key for Thunderforest resources ([@ahocevar](https://github.com/ahocevar))
 * [#6300](https://github.com/openlayers/openlayers/pull/6300) - Add missing hidpi option for ol.source.ImageArcGISRest ([@fredj](https://github.com/fredj))
 * [#6109](https://github.com/openlayers/openlayers/pull/6109) - Export Map as PNG (IE issue) ([@NaveenKY](https://github.com/NaveenKY))
 * [#6332](https://github.com/openlayers/openlayers/pull/6332) - Constrain the center in zoomByDelta ([@tchandelle](https://github.com/tchandelle))
 * [#6331](https://github.com/openlayers/openlayers/pull/6331) - Remove unused map parameter from ol.interaction.Interaction ([@tchandelle](https://github.com/tchandelle))
 * [#6326](https://github.com/openlayers/openlayers/pull/6326) - Add lineDashOffset to stroke style ([@tchandelle](https://github.com/tchandelle))
 * [#6328](https://github.com/openlayers/openlayers/pull/6328) - ol.geom.polygon documentation update on the coordinates format ([@quentin-ol](https://github.com/quentin-ol))
 * [#6324](https://github.com/openlayers/openlayers/pull/6324) - Ensure resolution stays in range when pinching ([@tschaub](https://github.com/tschaub))
 * [#6329](https://github.com/openlayers/openlayers/pull/6329) - Fix WMTS theme location for sea-levels layer ([@thomasmoelhave](https://github.com/thomasmoelhave))
 * [#6323](https://github.com/openlayers/openlayers/pull/6323) - Fix typo in Introduction ([@hdsnet](https://github.com/hdsnet))
 * [#6305](https://github.com/openlayers/openlayers/pull/6305) - Moved hit Tolerance parameter to own example. ([@KlausBenndorf](https://github.com/KlausBenndorf))
 * [#6319](https://github.com/openlayers/openlayers/pull/6319) - Remove the '3' from OpenLayers ([@ahocevar](https://github.com/ahocevar))
 * [#6314](https://github.com/openlayers/openlayers/pull/6314) - WebGL conditional compilation ([@ahocevar](https://github.com/ahocevar))
 * [#6313](https://github.com/openlayers/openlayers/pull/6313) - Remove ol.DEBUG ([@tschaub](https://github.com/tschaub))
 * [#6317](https://github.com/openlayers/openlayers/pull/6317) - Update sinon to version 1.17.7 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6312](https://github.com/openlayers/openlayers/pull/6312) - Make layers responsible for creating layer renderers ([@tschaub](https://github.com/tschaub))
 * [#6308](https://github.com/openlayers/openlayers/pull/6308) - Dedicated modules for shared enums ([@tschaub](https://github.com/tschaub))
 * [#6307](https://github.com/openlayers/openlayers/pull/6307) - Dedicated modules for enums ([@tschaub](https://github.com/tschaub))
 * [#6297](https://github.com/openlayers/openlayers/pull/6297) - Update resemblejs to version 2.2.3 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6296](https://github.com/openlayers/openlayers/pull/6296) - Fix #6295. Update reference link in sphere.js ([@jbelien](https://github.com/jbelien))
 * [#6255](https://github.com/openlayers/openlayers/pull/6255) - Don't reset the css cursor if it's not needed ([@fredj](https://github.com/fredj))
 * [#6290](https://github.com/openlayers/openlayers/pull/6290) - Use interim tiles ([@ahocevar](https://github.com/ahocevar))
 * [#6291](https://github.com/openlayers/openlayers/pull/6291) - Document olx.AtPixelOptions#hitTolerance default value ([@fredj](https://github.com/fredj))
 * [#6283](https://github.com/openlayers/openlayers/pull/6283) - Avoid modifying coordinate in forEachLayerAtCoordinate ([@tschaub](https://github.com/tschaub))
 * [#6278](https://github.com/openlayers/openlayers/pull/6278) - Add missing require for ol.View ([@tschaub](https://github.com/tschaub))
 * [#6280](https://github.com/openlayers/openlayers/pull/6280) - Continue loading tiles when image is not ready yet ([@ahocevar](https://github.com/ahocevar))
 * [#6277](https://github.com/openlayers/openlayers/pull/6277) - Name modules more like their provide ([@tschaub](https://github.com/tschaub))
 * [#6264](https://github.com/openlayers/openlayers/pull/6264) - Remove the requirement to provide a size to ol.View#fit() ([@ahocevar](https://github.com/ahocevar))
 * [#6274](https://github.com/openlayers/openlayers/pull/6274) - Update clean-css to version 3.4.23 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6269](https://github.com/openlayers/openlayers/pull/6269) - Update derequire to version 2.0.6 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6270](https://github.com/openlayers/openlayers/pull/6270) - Add a magnify example ([@tschaub](https://github.com/tschaub))
 * [#6261](https://github.com/openlayers/openlayers/pull/6261) - Fit Zoomify view to image extent ([@ahocevar](https://github.com/ahocevar))
 * [#6259](https://github.com/openlayers/openlayers/pull/6259) - Simplify Zoomify example ([@ahocevar](https://github.com/ahocevar))
 * [#6260](https://github.com/openlayers/openlayers/pull/6260) - Enhance documentation for ol.View#fit ([@marcjansen](https://github.com/marcjansen))
 * [#6258](https://github.com/openlayers/openlayers/pull/6258) - Set geometry name properly ([@ahocevar](https://github.com/ahocevar))
 * [#6251](https://github.com/openlayers/openlayers/pull/6251) - Take image pixel ratio into account for rendered resolution ([@ahocevar](https://github.com/ahocevar))
 * [#6244](https://github.com/openlayers/openlayers/pull/6244) - Enforces spacing around commas ([@fredj](https://github.com/fredj))
 * [#6246](https://github.com/openlayers/openlayers/pull/6246) - Re-render vector tiles when layer has changed ([@ahocevar](https://github.com/ahocevar))
 * [#6243](https://github.com/openlayers/openlayers/pull/6243) - Consistent spacing between keys and values in object literal ([@fredj](https://github.com/fredj))
 * [#6238](https://github.com/openlayers/openlayers/pull/6238) - Update eslint to version 3.12.1 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6236](https://github.com/openlayers/openlayers/pull/6236) - Update clean-css to version 3.4.22 🚀 ([@openlayers](https://github.com/openlayers))
