# 4.1.0

## Summary

The v4.1.0 release includes features and fixes from 91 pull requests.

#### Interactive overview map

The extent rectangle on the overview map can now be dragged to control the view for the main map.

#### Setting min and max zoom for a view

You can now change the min or max zoom for a view after it has been created.  This can be useful if you want to limit how far out users can zoom based on changes in viewport width (use `view.setMinZoom()` for this).

#### Adding duplicate layers to a map throws

Previously, you could do this:
```js
map.addLayer(layer);
map.addLayer(layer);
```

However, after adding a duplicate layer, things failed if you tried to remove that layer.

Now, `map.addLayer()` throws if you try adding a layer that has already been added to the map.

#### Simpler `constrainResolution` configuration

The `constrainResolution` configuration for `ol.interaction.PinchZoom` and `ol.interaction.MouseWheelZoom`
can now be set directly with an option in `ol.interaction.defaults`:
```js
ol.interaction.defaults({
  constrainResolution: true
});
```

## Detailed changes

 * [#6675](https://github.com/openlayers/openlayers/pull/6675) - Reset cursor when translate interaction is removed or deactivated ([@tchandelle](https://github.com/tchandelle))
 * [#6707](https://github.com/openlayers/openlayers/pull/6707) - Set version when building ol package ([@tschaub](https://github.com/tschaub))
 * [#6706](https://github.com/openlayers/openlayers/pull/6706) - Add ol.source.Cluster#getDistance function ([@fredj](https://github.com/fredj))
 * [#6695](https://github.com/openlayers/openlayers/pull/6695) - Unique layers ([@tschaub](https://github.com/tschaub))
 * [#6704](https://github.com/openlayers/openlayers/pull/6704) - Include typedefs.js in closure compiler tutorial build configurations ([@openlayers](https://github.com/openlayers))
 * [#6702](https://github.com/openlayers/openlayers/pull/6702) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6693](https://github.com/openlayers/openlayers/pull/6693) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6691](https://github.com/openlayers/openlayers/pull/6691) - Move eslint globals to to test/.eslintrc ([@fredj](https://github.com/fredj))
 * [#6689](https://github.com/openlayers/openlayers/pull/6689) - Add new constrainResolution option to olx.interaction.DefaultsOptions ([@fredj](https://github.com/fredj))
 * [#6692](https://github.com/openlayers/openlayers/pull/6692) - Improve docs for MouseWheelZoom constrainResolution ([@ahocevar](https://github.com/ahocevar))
 * [#6687](https://github.com/openlayers/openlayers/pull/6687) - Clip image only if the layer extent intersects the view extent ([@tchandelle](https://github.com/tchandelle))
 * [#6686](https://github.com/openlayers/openlayers/pull/6686) - Update finishCoordinate in ol.interaction.Draw#removeLastPoint ([@fredj](https://github.com/fredj))
 * [#6682](https://github.com/openlayers/openlayers/pull/6682) - Add example, docs and typedef for MouseWheelZoom's constrainResolution option ([@ahocevar](https://github.com/ahocevar))
 * [#6683](https://github.com/openlayers/openlayers/pull/6683) - Add this jsdoc tag to ol.interaction.DragBox.defaultBoxEndCondition ([@fredj](https://github.com/fredj))
 * [#6681](https://github.com/openlayers/openlayers/pull/6681) - Add constrainResolution in olx.interaction.PinchZoomOptions typedef ([@fredj](https://github.com/fredj))
 * [#6671](https://github.com/openlayers/openlayers/pull/6671) - Add constraintResolution option to MouseWheelZoom for zoom with trackpad ([@kaiCu](https://github.com/kaiCu))
 * [#6680](https://github.com/openlayers/openlayers/pull/6680) - Remove ol.DRAG_BOX_HYSTERESIS_PIXELS define and add option ([@fredj](https://github.com/fredj))
 * [#6666](https://github.com/openlayers/openlayers/pull/6666) - Use the optional extent in ol.structs.RBush#getExtent ([@fredj](https://github.com/fredj))
 * [#6670](https://github.com/openlayers/openlayers/pull/6670) - fix(package): update browserify to version 14.3.0 ([@openlayers](https://github.com/openlayers))
 * [#6664](https://github.com/openlayers/openlayers/pull/6664) - Update async to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6659](https://github.com/openlayers/openlayers/pull/6659) - Add crossOrigin to examples using ol.style.Icon ([@openlayers](https://github.com/openlayers))
 * [#6658](https://github.com/openlayers/openlayers/pull/6658) - Fixes for raster source rendering ([@tschaub](https://github.com/tschaub))
 * [#6620](https://github.com/openlayers/openlayers/pull/6620) - Fix the parsing of flat coordinates in GML2 for 3D geometies ([@Jenselme](https://github.com/Jenselme))
 * [#6657](https://github.com/openlayers/openlayers/pull/6657) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6644](https://github.com/openlayers/openlayers/pull/6644) - Allow minZoom and maxZoom to be set on a view ([@tschaub](https://github.com/tschaub))
 * [#6636](https://github.com/openlayers/openlayers/pull/6636) - Add test for the metric unit displayed in the scaleline ([@fredj](https://github.com/fredj))
 * [#6598](https://github.com/openlayers/openlayers/pull/6598) - Add support of micrometers to scaleline ([@hajjimurad](https://github.com/hajjimurad))
 * [#6643](https://github.com/openlayers/openlayers/pull/6643) - Add common transforms by default ([@tschaub](https://github.com/tschaub))
 * [#6567](https://github.com/openlayers/openlayers/pull/6567) - Overlay visible before updating render position ([@nagytech](https://github.com/nagytech))
 * [#6634](https://github.com/openlayers/openlayers/pull/6634) - Fix custom build when openlayers is installed from yarn package manager ([@Toilal](https://github.com/Toilal))
 * [#6639](https://github.com/openlayers/openlayers/pull/6639) - Update async to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6635](https://github.com/openlayers/openlayers/pull/6635) - Add missing externs to custom builds examples ([@Toilal](https://github.com/Toilal))
 * [#6631](https://github.com/openlayers/openlayers/pull/6631) - Fix request image size caclulation ([@ahocevar](https://github.com/ahocevar))
 * [#6627](https://github.com/openlayers/openlayers/pull/6627) - Change css selector for user-select none ([@bartvde](https://github.com/bartvde))
 * [#6626](https://github.com/openlayers/openlayers/pull/6626) - Respect cacheSize for reprojected caches ([@ahocevar](https://github.com/ahocevar))
 * [#6623](https://github.com/openlayers/openlayers/pull/6623) - Fix outerWidth and outerHeight calculation in IE ([@ahocevar](https://github.com/ahocevar))
 * [#6625](https://github.com/openlayers/openlayers/pull/6625) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6622](https://github.com/openlayers/openlayers/pull/6622) - Fix proj4 type ([@gberaudo](https://github.com/gberaudo))
 * [#6617](https://github.com/openlayers/openlayers/pull/6617) - Use GeoServer/GWC caching when possible ([@ahocevar](https://github.com/ahocevar))
 * [#6614](https://github.com/openlayers/openlayers/pull/6614) - Filter write util method ([@adube](https://github.com/adube))
 * [#6616](https://github.com/openlayers/openlayers/pull/6616) - Fix closing tag in gml tests ([@fredj](https://github.com/fredj))
 * [#6612](https://github.com/openlayers/openlayers/pull/6612) - Add support for WFS 1.0.0 to ol.format.WFS#writeTransaction ([@Jenselme](https://github.com/Jenselme))
 * [#5887](https://github.com/openlayers/openlayers/pull/5887) - Interactive overview map ([@felixveysseyre](https://github.com/felixveysseyre))
 * [#6610](https://github.com/openlayers/openlayers/pull/6610) - Fix event type case of MSPointerDown ([@ahocevar](https://github.com/ahocevar))
 * [#6611](https://github.com/openlayers/openlayers/pull/6611) - Update jquery to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6609](https://github.com/openlayers/openlayers/pull/6609) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6606](https://github.com/openlayers/openlayers/pull/6606) - Reset dragSegments after vertex deletion ([@ahocevar](https://github.com/ahocevar))
 * [#6523](https://github.com/openlayers/openlayers/pull/6523) - Add Gml2 serializers to support WFS-T 1.0.0 ([@Jenselme](https://github.com/Jenselme))
 * [#6579](https://github.com/openlayers/openlayers/pull/6579) - Update slimerjs to v0.10.3 ([@fredj](https://github.com/fredj))
 * [#6577](https://github.com/openlayers/openlayers/pull/6577) - Adding crossOrigin to optionsFromCapabilities ([@fredj](https://github.com/fredj))
 * [#6604](https://github.com/openlayers/openlayers/pull/6604) - Fix RegularShape documentation ([@ahocevar](https://github.com/ahocevar))
 * [#6603](https://github.com/openlayers/openlayers/pull/6603) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6601](https://github.com/openlayers/openlayers/pull/6601) - Update jquery to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6600](https://github.com/openlayers/openlayers/pull/6600) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6578](https://github.com/openlayers/openlayers/pull/6578) - Add ol.RenderOrderFunction typedef ([@icholy](https://github.com/icholy))
 * [#6589](https://github.com/openlayers/openlayers/pull/6589) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6592](https://github.com/openlayers/openlayers/pull/6592) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6594](https://github.com/openlayers/openlayers/pull/6594) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6580](https://github.com/openlayers/openlayers/pull/6580) - Remove unused esprima package ([@fredj](https://github.com/fredj))
 * [#6570](https://github.com/openlayers/openlayers/pull/6570) - Don't use deprecated sinon.stub(obj, 'meth', fn) ([@openlayers](https://github.com/openlayers))
 * [#6569](https://github.com/openlayers/openlayers/pull/6569) - Return null if the layer was not found in the WMTS capabilities ([@fredj](https://github.com/fredj))
 * [#6551](https://github.com/openlayers/openlayers/pull/6551) - Use the default fill and stroke color ([@fredj](https://github.com/fredj))
 * [#6560](https://github.com/openlayers/openlayers/pull/6560) - Don’t crash if feature loader xhr response returns 500 ([@geosense](https://github.com/geosense))
 * [#6559](https://github.com/openlayers/openlayers/pull/6559) - Remove unneeded type cast ([@fredj](https://github.com/fredj))
 * [#6558](https://github.com/openlayers/openlayers/pull/6558) - Update coveralls to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6553](https://github.com/openlayers/openlayers/pull/6553) - Update proj4 to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6554](https://github.com/openlayers/openlayers/pull/6554) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6549](https://github.com/openlayers/openlayers/pull/6549) - Make getAnimating and cancelAnimations @api ([@bartvde](https://github.com/bartvde))
 * [#6547](https://github.com/openlayers/openlayers/pull/6547) - Clean up left-over code from animation changes ([@bartvde](https://github.com/bartvde))
 * [#6540](https://github.com/openlayers/openlayers/pull/6540) - More precise ol.Geolocation#getAccuracyGeometry return type ([@openlayers](https://github.com/openlayers))
 * [#6539](https://github.com/openlayers/openlayers/pull/6539) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6535](https://github.com/openlayers/openlayers/pull/6535) - Update closure-util to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6529](https://github.com/openlayers/openlayers/pull/6529) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6530](https://github.com/openlayers/openlayers/pull/6530) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6515](https://github.com/openlayers/openlayers/pull/6515) - Add view methods for getting max zoom, min zoom, and any zoom for a resolution ([@tschaub](https://github.com/tschaub))
 * [#6520](https://github.com/openlayers/openlayers/pull/6520) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6518](https://github.com/openlayers/openlayers/pull/6518) - Fix olx.style.IconOptions.prototype.src type ([@fredj](https://github.com/fredj))
 * [#6513](https://github.com/openlayers/openlayers/pull/6513) - Update async to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6512](https://github.com/openlayers/openlayers/pull/6512) - Complete animations at target values ([@tschaub](https://github.com/tschaub))
 * [#6511](https://github.com/openlayers/openlayers/pull/6511) - Revert accidently committed example change ([@ahocevar](https://github.com/ahocevar))
 * [#6507](https://github.com/openlayers/openlayers/pull/6507) - ol.DEBUG no longer needed in transforms/module.js ([@probins](https://github.com/probins))
 * [#6505](https://github.com/openlayers/openlayers/pull/6505) - Update ol package to include Browserify config ([@tschaub](https://github.com/tschaub))
 * [#6504](https://github.com/openlayers/openlayers/pull/6504) - Determine if we should handle the drawing while the pointer is moving ([@tchandelle](https://github.com/tchandelle))
 * [#6499](https://github.com/openlayers/openlayers/pull/6499) - Be more tolerant when comparing vertices when modifying a circle ([@tchandelle](https://github.com/tchandelle))
 * [#6498](https://github.com/openlayers/openlayers/pull/6498) - Travis failing on master - use Node v6.1.x ([@ahocevar](https://github.com/ahocevar))
 * [#6493](https://github.com/openlayers/openlayers/pull/6493) - Vector tile cleanup ([@ahocevar](https://github.com/ahocevar))
 * [#6483](https://github.com/openlayers/openlayers/pull/6483) - Fix renderer.canvas.TileLayer to calculate correct canvas height for drawing. ([@nearmap](https://github.com/nearmap))
 * [#6488](https://github.com/openlayers/openlayers/pull/6488) - Do not draw circle when pointer not moved and freehand is on ([@tchandelle](https://github.com/tchandelle))
 * [#6491](https://github.com/openlayers/openlayers/pull/6491) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
