# 4.3.0

## Summary

The v4.3.0 release includes features and fixes from 92 pull requests.

#### New `map.getFeaturesAtPixel()` method

When you want to get all features at a given pixel, use the new `map.getFeaturesAtPixel()` method.

Before:
```js
var features = [];
map.forEachFeatureAtPixel(pixel, function(feature) {
  features.push(feature);
});
```

After:
```js
var features = map.getFeaturesAtPixel(pixel);
```

#### `ol.Sphere` functions for spherical measures

The new `ol.Sphere.getArea()` and `ol.Sphere.getLength()` methods can be used to calculate spherical measures on geometries.  This is the recommended over using the `geometry.getArea()` or `geometry.getLength()` methods.

Bad:
```js
geometry.getArea();
```

Good:
```js
ol.Sphere.getArea(geometry);
```

#### `ol.interaction.DragAndDrop` can be configured with a vector source

It is now possible to configure the drag and drop interaction with a vector source:

```js
var dragAndDrop = new ol.interaction.DragAndDrop({source: source});
```

Any dropped features will replace all existing features on the source.

#### `ol.interaction.Modify` can be configured with a vector source

It is now possible to configure the modify interaction with a vector source (in addition to a feature collection):

```js
var modify = new ol.interaction.Modify({source: source});
```

With this configuration, all features on the source are eligible for modification while the interaction is active.

#### `ol.interaction.Modify` deletes with `alt` key only

To delete features with the modify interaction, press the `alt` key while clicking on an existing vertex.  If you want to configure the modify interaction with a different delete condition, use the `deleteCondition` option.  For example, to allow deletion on a single click with no modifier keys, configure the interaction like this:
```js
var interaction = new ol.interaction.Modify({
  source: source,
  deleteCondition: function(event) {
    return ol.events.condition.noModifierKeys(event) && ol.events.condition.singleClick(event);
  }
});
```

The motivation for this change is to make the modify, draw, and snap interactions all work well together.  Previously, the use of these interactions with the default configuration would make it so you couldn't reliably add new vertices (click with no modifier) and delete existing vertices (click with no modifier).

#### `ol.source.VectorTile` no longer requires a `tileGrid` option

By default, the `ol.source.VectorTile` constructor creates an XYZ tile grid (in Web Mercator) for 512 pixel tiles and assumes a max zoom level of 22.  If you were creating a vector tile source with an explicit `tileGrid` option, you can now remove this.

Before:
```js
var source = new ol.source.VectorTile({
  tileGrid: ol.tilegrid.createXYZ({tileSize: 512, maxZoom: 22}),
  url: url
});
```

After:
```js
var source = new ol.source.VectorTile({
  url: url
});
```

If you need to change the max zoom level, you can pass the source a `maxZoom` option.  If you need to change the tile size, you can pass the source a `tileSize` option.  If you need a completely custom tile grid, you can still pass the source a `tileGrid` option.

#### `ol.source.VectorTile` no longer has a `tilePixelRatio` option

The `tilePixelRatio` option was only used for tiles in projections with `tile-pixels` as units. For tiles read with `ol.format.MVT` and the default tile loader, or tiles with the default pixel size of 4096 pixels, no changes are necessary. For the very rare cases that do not fall under these categories, a custom `tileLoadFunction` now needs to be configured on the `ol.source.VectorTile`. In addition to calling `tile.setFeatures()` and `tile.setProjection()`, it also needs to contain code like the following:
```js
var extent = tile.getFormat() instanceof ol.format.MVT ?
  tile.getLastExtent() :
  [0, 0, tilePixelRatio * tileSize, tilePixelRatio * tileSize];
tile.setExtent(extent);
```

#### `ol.animate` now takes the shortest arc for rotation animation

Usually rotation animations should animate along the shortest arc. There are rare occasions where a spinning animation effect is desired. So if you previously had something like
```js
map.getView().animate({
  rotation: 2 * Math.PI,
  duration: 2000
});
```
we recommend to split the animation into two parts and use different easing functions. The code below results in the same effect as the snippet above did with previous versions:
```js
map.getView().animate({
  rotation: Math.PI,
  easing: ol.easing.easeIn
}, {
  rotation: 2 * Math.PI,
  easing: ol.easing.easeOut
});
```

## Full List of Changes

 * [#7117](https://github.com/openlayers/openlayers/pull/7117) - Sensible default tilegrid for vector tiles ([@tschaub](https://github.com/tschaub))
 * [#7116](https://github.com/openlayers/openlayers/pull/7116) - fix(package): update rollup to version 0.47.2 ([@openlayers](https://github.com/openlayers))
 * [#7111](https://github.com/openlayers/openlayers/pull/7111) - Remove broken wrapX handling from ol.Graticule ([@ahocevar](https://github.com/ahocevar))
 * [#7107](https://github.com/openlayers/openlayers/pull/7107) - Update rollup to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7106](https://github.com/openlayers/openlayers/pull/7106) - Update proj4 to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7105](https://github.com/openlayers/openlayers/pull/7105) - Functions for spherical calculations ([@tschaub](https://github.com/tschaub))
 * [#7104](https://github.com/openlayers/openlayers/pull/7104) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6807](https://github.com/openlayers/openlayers/pull/6807) - Initialize hasZ in the constructor of GML3 ([@Jenselme](https://github.com/Jenselme))
 * [#7102](https://github.com/openlayers/openlayers/pull/7102) - Allow drag and drop interaction to be configured with a source ([@tschaub](https://github.com/tschaub))
 * [#6825](https://github.com/openlayers/openlayers/pull/6825) - Read/write Tessellate tag in KML format ([@oterral](https://github.com/oterral))
 * [#7098](https://github.com/openlayers/openlayers/pull/7098) - Use fractional coordinates for CSS positioning ([@ahocevar](https://github.com/ahocevar))
 * [#7064](https://github.com/openlayers/openlayers/pull/7064) - Do not use Array.prototype.forEach when dealing with potentially large arrays ([@ahocevar](https://github.com/ahocevar))
 * [#7093](https://github.com/openlayers/openlayers/pull/7093) - Allow modify interaction to be configured with a source ([@tschaub](https://github.com/tschaub))
 * [#7096](https://github.com/openlayers/openlayers/pull/7096) - Add new Map#getFeaturesAtPixel method ([@ahocevar](https://github.com/ahocevar))
 * [#7094](https://github.com/openlayers/openlayers/pull/7094) - Add missing zIndex options ([@icholy](https://github.com/icholy))
 * [#7087](https://github.com/openlayers/openlayers/pull/7087) - Fix scale line for EPSG:4326 maps ([@ahocevar](https://github.com/ahocevar))
 * [#7088](https://github.com/openlayers/openlayers/pull/7088) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7085](https://github.com/openlayers/openlayers/pull/7085) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7084](https://github.com/openlayers/openlayers/pull/7084) - Fix a typo in the street-labels example ([@ahocevar](https://github.com/ahocevar))
 * [#7082](https://github.com/openlayers/openlayers/pull/7082) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7079](https://github.com/openlayers/openlayers/pull/7079) - Optimize custom renderer code, examples and API ([@ahocevar](https://github.com/ahocevar))
 * [#7080](https://github.com/openlayers/openlayers/pull/7080) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7078](https://github.com/openlayers/openlayers/pull/7078) - Fix return type annotation of ol.layer.VectorTile.getSource ([@geosense](https://github.com/geosense))
 * [#7073](https://github.com/openlayers/openlayers/pull/7073) - Make ol.layer.Group change handling consistent ([@gberaudo](https://github.com/gberaudo))
 * [#7075](https://github.com/openlayers/openlayers/pull/7075) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7072](https://github.com/openlayers/openlayers/pull/7072) - Improve API docs for ol.VectorTile ([@ahocevar](https://github.com/ahocevar))
 * [#7070](https://github.com/openlayers/openlayers/pull/7070) - Get tilePixelRatio from MVT tiles ([@ahocevar](https://github.com/ahocevar))
 * [#7069](https://github.com/openlayers/openlayers/pull/7069) - Update mocha to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7068](https://github.com/openlayers/openlayers/pull/7068) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7066](https://github.com/openlayers/openlayers/pull/7066) - Fix ol.interaction.Extent event type and documentation ([@ahocevar](https://github.com/ahocevar))
 * [#7032](https://github.com/openlayers/openlayers/pull/7032) - Fix KML Export Icon Anchor ([@raiyni](https://github.com/raiyni))
 * [#7065](https://github.com/openlayers/openlayers/pull/7065) - Only use API functions in example ([@ahocevar](https://github.com/ahocevar))
 * [#7022](https://github.com/openlayers/openlayers/pull/7022) - Allow styles to configure a custom renderer ([@ahocevar](https://github.com/ahocevar))
 * [#7061](https://github.com/openlayers/openlayers/pull/7061) - Update docs and issue and pull request instructions ([@ahocevar](https://github.com/ahocevar))
 * [#7059](https://github.com/openlayers/openlayers/pull/7059) - Allow to configure Extent interaction with an extent ([@ahocevar](https://github.com/ahocevar))
 * [#7060](https://github.com/openlayers/openlayers/pull/7060) - Removing invalid urn ([@wnordmann](https://github.com/wnordmann))
 * [#7051](https://github.com/openlayers/openlayers/pull/7051) - Changing the EPSG3857.PROJECTION array assignment and adding urn:ogc:… ([@wnordmann](https://github.com/wnordmann))
 * [#7045](https://github.com/openlayers/openlayers/pull/7045) - Respect pixelRatio when scaling images ([@ahocevar](https://github.com/ahocevar))
 * [#7023](https://github.com/openlayers/openlayers/pull/7023) - Update tile size and resolutions of vector tile examples ([@ahocevar](https://github.com/ahocevar))
 * [#7005](https://github.com/openlayers/openlayers/pull/7005) - Add spatial reference inside geometry in EsriFormat ([@Sol1du2](https://github.com/Sol1du2))
 * [#7034](https://github.com/openlayers/openlayers/pull/7034) - Move non-build dependencies to devDependencies ([@probins](https://github.com/probins))
 * [#7050](https://github.com/openlayers/openlayers/pull/7050) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6976](https://github.com/openlayers/openlayers/pull/6976) - Example - Earthquake Clusters - Change evt.type of interaction ([@ehanoj](https://github.com/ehanoj))
 * [#7048](https://github.com/openlayers/openlayers/pull/7048) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7041](https://github.com/openlayers/openlayers/pull/7041) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7042](https://github.com/openlayers/openlayers/pull/7042) - Line dash offset ([@gkresic](https://github.com/gkresic))
 * [#6980](https://github.com/openlayers/openlayers/pull/6980) - Added tileClass to TileWMS ([@ZachTRice](https://github.com/ZachTRice))
 * [#7028](https://github.com/openlayers/openlayers/pull/7028) - Fix Graticule use of incorrect min/maxLon values ([@greggian](https://github.com/greggian))
 * [#7021](https://github.com/openlayers/openlayers/pull/7021) - Update fs-extra to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7018](https://github.com/openlayers/openlayers/pull/7018) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7015](https://github.com/openlayers/openlayers/pull/7015) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7014](https://github.com/openlayers/openlayers/pull/7014) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7013](https://github.com/openlayers/openlayers/pull/7013) - Remove ol.sphere.WGS84 and ol.sphere.NORMAL ([@tschaub](https://github.com/tschaub))
 * [#6981](https://github.com/openlayers/openlayers/pull/6981) - Render transparent vector layers to an intermediate canvas ([@gberaudo](https://github.com/gberaudo))
 * [#6899](https://github.com/openlayers/openlayers/pull/6899) - Use number literal for sphere radius ([@probins](https://github.com/probins))
 * [#7011](https://github.com/openlayers/openlayers/pull/7011) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7008](https://github.com/openlayers/openlayers/pull/7008) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7007](https://github.com/openlayers/openlayers/pull/7007) - fix(package): update rollup to version 0.45.0 ([@openlayers](https://github.com/openlayers))
 * [#6996](https://github.com/openlayers/openlayers/pull/6996) - 6987: Memory leak with WMS time source with reprojection ([@ch08532](https://github.com/ch08532))
 * [#7003](https://github.com/openlayers/openlayers/pull/7003) - Update jsdoc to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#7004](https://github.com/openlayers/openlayers/pull/7004) - Use https for bing and stamen attributions ([@fredj](https://github.com/fredj))
 * [#6998](https://github.com/openlayers/openlayers/pull/6998) - Update eslint to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6999](https://github.com/openlayers/openlayers/pull/6999) - Make VectorTile source work with multiple layers ([@ahocevar](https://github.com/ahocevar))
 * [#6988](https://github.com/openlayers/openlayers/pull/6988) - Add missing type annotations ([@ahocevar](https://github.com/ahocevar))
 * [#6984](https://github.com/openlayers/openlayers/pull/6984) - Update closure-util to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6970](https://github.com/openlayers/openlayers/pull/6970) - Fix Bug when adding/removing layer with no cache ([@cmortazavi](https://github.com/cmortazavi))
 * [#6972](https://github.com/openlayers/openlayers/pull/6972) - Handle error tiles properly ([@ahocevar](https://github.com/ahocevar))
 * [#6973](https://github.com/openlayers/openlayers/pull/6973) - Update clean-css-cli to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6971](https://github.com/openlayers/openlayers/pull/6971) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6968](https://github.com/openlayers/openlayers/pull/6968) - Shortest arc rotation animation improvements and upgrade notes ([@ahocevar](https://github.com/ahocevar))
 * [#6966](https://github.com/openlayers/openlayers/pull/6966) - Add getResolutionForZoom method for ol.View ([@ahocevar](https://github.com/ahocevar))
 * [#6965](https://github.com/openlayers/openlayers/pull/6965) - Use shortest rotation delta for animation ([@ahocevar](https://github.com/ahocevar))
 * [#6967](https://github.com/openlayers/openlayers/pull/6967) - Add RoadOnDemand imagery set to Bing example ([@ahocevar](https://github.com/ahocevar))
 * [#6964](https://github.com/openlayers/openlayers/pull/6964) - Fix KML ExtendedData reading ([@fredj](https://github.com/fredj))
 * [#6958](https://github.com/openlayers/openlayers/pull/6958) - Remove error tiles after loading is finished ([@ahocevar](https://github.com/ahocevar))
 * [#6793](https://github.com/openlayers/openlayers/pull/6793) - Webgl text ([@GaborFarkas](https://github.com/GaborFarkas))
 * [#6960](https://github.com/openlayers/openlayers/pull/6960) - Queue tiles before loading ([@tschaub](https://github.com/tschaub))
 * [#6957](https://github.com/openlayers/openlayers/pull/6957) - Greenkeeper/eslint 4.1.1 ([@openlayers](https://github.com/openlayers))
 * [#6955](https://github.com/openlayers/openlayers/pull/6955) - Update async to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6916](https://github.com/openlayers/openlayers/pull/6916) - Upgrade eslint to v4.0.0 ([@marcjansen](https://github.com/marcjansen))
 * [#6943](https://github.com/openlayers/openlayers/pull/6943) - Update sinon to the latest version 🚀 ([@openlayers](https://github.com/openlayers))
 * [#6939](https://github.com/openlayers/openlayers/pull/6939) - Abort loading when tile is disposed ([@ahocevar](https://github.com/ahocevar))
 * [#6930](https://github.com/openlayers/openlayers/pull/6930) - Handle setActive(false) on an interaction without map ([@openlayers](https://github.com/openlayers))
 * [#6936](https://github.com/openlayers/openlayers/pull/6936) - Do not stop the render loop when all wanted tiles are aborted ([@ahocevar](https://github.com/ahocevar))
 * [#6920](https://github.com/openlayers/openlayers/pull/6920) - Fix minor type strength inconsistency ([@klokantech](https://github.com/klokantech))
 * [#6935](https://github.com/openlayers/openlayers/pull/6935) - Use transparent image from canvas context ([@ahocevar](https://github.com/ahocevar))
 * [#6933](https://github.com/openlayers/openlayers/pull/6933) - Improve proj.get() logic ([@probins](https://github.com/probins))
 * [#6931](https://github.com/openlayers/openlayers/pull/6931) - Make sure we use the default featurePrefix ([@bartvde](https://github.com/bartvde))
 * [#6928](https://github.com/openlayers/openlayers/pull/6928) - Only adjust resolution when center within projection extent ([@ahocevar](https://github.com/ahocevar))
 * [#6923](https://github.com/openlayers/openlayers/pull/6923) - Load tasks/build-ext.js in strict mode ([@fredj](https://github.com/fredj))
 * [#6918](https://github.com/openlayers/openlayers/pull/6918) - Remove unnecessary pixelRatio check ([@ahocevar](https://github.com/ahocevar))
 * [#6917](https://github.com/openlayers/openlayers/pull/6917) - Correct typo in graticule docs ([@probins](https://github.com/probins))
