# **pixelworks**

Utilities for working with [`ImageData`](https://developer.mozilla.org/en-US/docs/Web/API/ImageData) in [`Workers`](https://developer.mozilla.org/en-US/docs/Web/API/Worker/Worker).

## Install

The `pixelworks` package is meant to be used in a browser with a CommonJS module loader (e.g. [Browserify](http://browserify.org/) or [Webpack](http://webpack.github.io/)).  Add it as a dependency to your project with `npm`:

    npm install pixelworks

## Use

    var pixelworks = require('pixelworks');

The package also comes with a standalone build in the `dist` directory that can be added to a page with a script tag.  If a module loader is not present, this script will make a global `pixelworks` object available.

## API

### `new Processor(options)`

A processor runs pixel or image operations in workers.

    var processor = new pixelworks.Processor(options);

#### Supported options

 * <a id="optionsimageops">`imageOps : boolean`</a> - By default, operations will be called for each pixel.  By setting `imageOps: true`, operations will be called with an `ImageData` object.

 * <a id="optionsoperations">`operation : Function`</a> - A function that processes input data and returns output data.  The operation will be called with two arguments: an array of inputs, and a user storage object.  By default, operations will be called for each pixel in the input data, and the first argument is an array of input pixels (each a `[R, G, B, A]` array).  If `imageOps` is `false`, the first argument will be an array of `ImageData` objects.  The second object is the user storage object passed to the `process` method.

 Operations return processed output data.  For pixel-wise operations, this must be an output pixel (a `[R, G, B, A]` array).  For image operations, this must be an `ImageData` object.

 Because operations run in workers, they must only operate on the arguments they are given.

 * <a id="optionslib">`lib : Object`</a> - An optional lookup of functions that can be accessed by an operation run in a worker.  Because operations are run in workers, they cannot access functions from the scope where they are authored.  The `lib` object can be used to pass additional library functions that are made available in the worker scope.  For example, if `{lib: {someFunc: function() {/* do something */}}}` were provided, the operation could call `someFunc()`.

 * <a id="optionsthreads">`threads : number`</a> - Pixel-wise operations can be run in parallel in multiple worker threads.  By default, a single worker thread is created for running operations.  Setting `threads: 2` would process half of the input pixels in one thread and half in another.  For image type operations, `threads` cannot be greater than `1`.  If you want to force operations to run in the main (UI) thread, set `threads: 0`.

 * <a id="optionsqueue">`queue : number`</a> - Maximum queue length.  This limits the number of pending workers when `process` is called multiple times before work completes.  If you want to call `process` many times (in response to user generated events for example), set `queue: 1`, and only one worker will be pending at a time.

### `processor.process(inputs, meta, callback)`

Run the operation on an array of input image data.

 * `inputs : Array.<ImageData>` - Array of pixels or image data (depending on the operation type).
 * `meta : Object` - A user data object.  This is passed to all operations and must be serializable.
 * `callback : function(Error, ImageData, Object)` - Called when work completes.  The first argument is any error.  The second is the `ImageData` generated by the operation.  The third is the user data object.  When `process` is called repeatedly, a queue of pending workers will be generated.  If this queue exceeds the maximum `queue` length, workers will be removed from the queue and the callback will be called with `null` for the second `ImageData` argument.

### `processor.destroy()`

Stop responding to any completed work and destroy the processor.


[![Current Status](https://secure.travis-ci.org/tschaub/pixelworks.svg?branch=master)](https://travis-ci.org/tschaub/pixelworks)
